gameOverSong = 'hiverDeath';
lossSFXName = 'gameover/hiver/gameOver';
retrySFX = 'gameover/hiver/deathEnd';
//lossSFXName = "cdi/kingDeath";
var enterSound:FlxSound = FlxG.sound.load(Paths.sound("gameover/hiver/deathEnd"));

var lines:Sound;

var gameoverSprite:FlxSprite = new FlxSprite();
gameoverSprite.frames = Paths.getFrames("stages/hiver/sadisticgameover");
gameoverSprite.animation.addByPrefix("loop", "Symbol 1", 24, true);
gameoverSprite.animation.addByPrefix("enter", "Symbol 2", 24, false);
gameoverSprite.animation.addByPrefix("enterLoop", "Symbol 3", 24, true);
//gameoverSprite.scale.set(0.5, 0.5);
gameoverSprite.updateHitbox();
gameoverSprite.screenCenter();
gameoverSprite.antialiasing = true;

function create () {
    
	add(gameoverSprite);
	gameoverSprite.animation.play('loop');
	lines = Paths.sound('gameover/hiver/line' + FlxG.random.int(1, 6));
	gameoverSprite.y = 720;
	
}

function postCreate() {
	//trace(gameoverSprite.y);
	character.visible = false;
	camOver = new FlxCamera(0, 0, 960, 720);
	camOver.bgColor = FlxColor.BLACK;
	FlxG.cameras.add(camOver, false);
	gameoverSprite.cameras = [camOver];
	FlxTween.tween(gameoverSprite, {y: 90}, 0.8, {startDelay: 0.7, ease: FlxEase.circOut});
	
}

function beatHit(cur:Int) {
	if(cur != 0) return;
	FlxG.sound.play(lines, 1, false, null, true);
}

function onEnd(event) {
    event.cancel();
	FlxTween.cancelTweensOf(gameoverSprite);
	FlxG.sound.music.stop();
	enterSound.play(true);
	camOver.flash(FlxColor.ORANGE, 0.2);
	camOver.shake(0.002, 1.4, null, true);
	gameoverSprite.animation.play('enter', true);
	gameoverSprite.animation.finishCallback = function (name:String) {
        if(name == 'enter') gameoverSprite.animation.play('enterLoop', true);
	}
	trace("entere");
	new FlxTimer().start(2.2, function(tmr:FlxTimer)
		{
            
			camOver.fade(FlxColor.BLACK, 3, false, function()
				{
					FlxG.switchState(new PlayState());
				});
			
		});

}